# Botamation Woocommerce Tools

A comprehensive WordPress plugin that provides webhook notification capabilities for WooCommerce abandoned cart recovery and order lifecycle management. This plugin helps automate your e-commerce workflows by sending real-time webhook notifications for cart abandonment and order events.

## Features

### 🛒 Abandoned Cart Recovery
- **Smart Cart Tracking**: Automatically captures guest and logged-in user cart data with phone number collection
- **Configurable Timing**: Set custom reminder delays (default: 15 minutes after cart abandonment)
- **Self-Rescheduling Cron**: Efficient single-event cron jobs that automatically reschedule based on settings
- **Duplicate Prevention**: Intelligent tracking prevents multiple notifications for the same cart
- **Cart Restoration**: Webhook includes restoration URLs for one-click cart recovery
- **Guest Phone Capture**: AJAX-powered phone number collection during checkout
- **Auto Cleanup**: Configurable cleanup of old cart records (default: 60 hours)

### 📦 Order Lifecycle Notifications
- **Multi-Event Support**: Track order creation, updates, and cancellations
- **Action-Specific Webhooks**: Configure unique webhook URLs for different order events
- **Duplicate Prevention**: Built-in safeguards prevent multiple notifications for the same event
- **Rich Payload Data**: Comprehensive order information including billing, shipping, items, and totals
- **Real-Time Processing**: Immediate webhook dispatch when order events occur
- **Status Change Tracking**: Intelligent detection of actual status changes vs. duplicate calls

### 🔧 Admin Interface
- **Centralized Management**: Single "Botamation Tools" menu for all features
- **Dynamic UI Controls**: Smart enable/disable states for Save and Test buttons
- **Inline Configuration**: Streamlined settings with immediate feedback
- **Test Capabilities**: Send test webhooks to verify endpoint configuration
- **Visual Feedback**: Clear success/error messages for all operations
- **Remove Actions**: Easy removal of configured webhook endpoints

## Installation

1. Upload the plugin files to `/wp-content/plugins/botamation-woocommerce-tools/`
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Ensure WooCommerce is installed and activated
4. Navigate to **Botamation Tools** in your WordPress admin menu

## Configuration

### Abandoned Cart Setup

1. Go to **Botamation Tools → Abandoned Cart Notification**
2. Configure your webhook URL (where notifications will be sent)
3. Set your preferred reminder delay in minutes
4. Click **Save** to activate the system
5. Use **Send Test Data** to verify your webhook endpoint

### Order Notification Setup

1. Go to **Botamation Tools → Order Notification**
2. Choose an action from the dropdown (Create, Update, or Cancel)
3. Click **Add** to reveal the configuration section
4. Enter your webhook URL for that specific action
5. Click **Save** to activate notifications for that action
6. Use **Send Test Data** to verify the endpoint
7. Repeat for additional actions as needed

## Webhook Payloads

### Abandoned Cart Payload

```json
{
  "generated_at": "2025-10-25 14:30:00",
  "cart_id": "abc123",
  "session_id": "sess_456",
  "user_id": 0,
  "status": "abandoned",
  "contact": {
    "phone": "+1234567890",
    "email": "customer@example.com"
  },
  "billing": {
    "first_name": "John",
    "last_name": "Doe",
    "company": "Example Corp",
    "email": "john@example.com",
    "phone": "+1234567890",
    "address_1": "123 Main St",
    "address_2": "Apt 4B",
    "city": "New York",
    "state": "NY",
    "postcode": "10001",
    "country": "US"
  },
  "shipping": { /* Same structure as billing */ },
  "items": [
    {
      "product_id": 123,
      "variation_id": 0,
      "name": "Product Name",
      "price": 29.99,
      "quantity": 2,
      "subtotal": 59.98,
      "image": "https://example.com/image.jpg",
      "variation": {}
    }
  ],
  "total_products_with_tax": 65.98,
  "cart_url": "https://yoursite.com/restore-cart?token=xyz",
  "checkout_url": "https://yoursite.com/checkout?restore=xyz"
}
```

### Order Notification Payload

```json
{
  "generated_at": "2025-10-25 14:30:00",
  "action": "create",
  "order_id": 456,
  "order_number": "ORD-2025-001",
  "status": "processing",
  "currency": "USD",
  "billing": { /* Same structure as abandoned cart */ },
  "shipping": { /* Same structure as abandoned cart */ },
  "contact": {
    "phone": "+1234567890",
    "email": "customer@example.com"
  },
  "items": [
    {
      "product_id": 123,
      "variation_id": 0,
      "name": "Product Name",
      "price": 29.99,
      "quantity": 1,
      "subtotal": 29.99,
      "image": "https://example.com/image.jpg",
      "variation": {}
    }
  ],
  "total_products_with_tax": 32.99,
  "invoice_url": "https://yoursite.com/my-account/view-order/456"
}
```

### Test Payloads

Both modules include test functionality that sends synthetic data with a `"test": true` flag to help you verify your webhook endpoints are working correctly.

## Technical Details

### Database Schema

The plugin creates a custom table `wp_acn_carts` with the following structure:

```sql
CREATE TABLE wp_acn_carts (
  id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  cart_id varchar(255) NOT NULL,
  session_id varchar(255) DEFAULT NULL,
  user_id bigint(20) unsigned DEFAULT 0,
  contact_data text,
  cart_data text,
  status varchar(50) DEFAULT 'active',
  created_at datetime NOT NULL,
  last_updated datetime NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY cart_id (cart_id),
  KEY session_id (session_id),
  KEY user_id (user_id),
  KEY status (status),
  KEY last_updated (last_updated)
);
```

### Cron Jobs

- **Cart Processing**: Single-event cron that self-reschedules based on settings
- **Cleanup**: Daily cron job removes cart records older than 60 hours
- **UTC Handling**: All time comparisons use UTC for reliability across timezones

### WordPress Integration

- **Options API**: Settings stored using WordPress options with proper sanitization
- **Admin Menus**: Clean integration with WordPress admin interface
- **AJAX Handling**: Secure phone number capture with nonce verification
- **Session Management**: WooCommerce session integration for guest cart tracking
- **Meta Data**: Order meta prevents duplicate webhook sends

## Requirements

- WordPress 5.0 or higher
- WooCommerce 3.0 or higher
- PHP 7.4 or higher
- MySQL 5.6 or higher

## Hooks and Filters

The plugin integrates with WooCommerce using these hooks:

- `woocommerce_cart_updated` - Captures cart changes
- `woocommerce_new_order` - Triggers order creation webhooks
- `woocommerce_order_status_changed` - Handles order status updates
- `wp_ajax_acn_save_phone` - AJAX phone number capture
- `wp_ajax_nopriv_acn_save_phone` - Guest phone capture

## Performance Considerations

- **Efficient Queries**: Optimized database queries with proper indexing
- **Background Processing**: Webhook sends don't block user experience
- **Smart Scheduling**: Cron jobs only run when needed
- **Memory Management**: Proper cleanup of temporary data
- **HTTP Timeouts**: Reasonable 15-second timeout for webhook requests

## Security Features

- **Nonce Verification**: All admin actions protected with WordPress nonces
- **Data Sanitization**: Input validation and output escaping throughout
- **Capability Checks**: Admin functions restricted to appropriate users
- **SQL Injection Prevention**: Prepared statements for all database operations
- **XSS Protection**: Proper escaping of all output

## Troubleshooting

### Webhooks Not Sending

1. Check your webhook URL is accessible from your server
2. Verify the URL returns HTTP 200 status codes
3. Review error logs for connection issues
4. Test with the built-in "Send Test Data" functionality

### Cron Jobs Not Running

1. Ensure WordPress cron is enabled (not disabled in wp-config.php)
2. Check if a cron service like WP-Cron Control is interfering
3. Verify the remind delay setting is appropriate
4. Look for PHP errors in your error logs

### Phone Numbers Not Capturing

1. Ensure AJAX is working on your checkout page
2. Check for JavaScript errors in browser console
3. Verify the checkout form includes standard WooCommerce fields
4. Test with default WooCommerce theme to rule out theme conflicts

## Support

For support and updates, contact Botamation or visit our documentation portal.

## License

This plugin is proprietary software developed by Botamation. All rights reserved.

## Changelog

### Version 1.0.0
- Initial release
- Abandoned cart tracking and notifications
- Order lifecycle webhook notifications
- Admin interface with test capabilities
- UTC time handling and cleanup functionality
- Guest phone number capture
- Cart restoration URLs