jQuery(function ($) {
    if (!$('body').hasClass('woocommerce-checkout')) {
        return;
    }

    // Support both classic checkout and Checkout Blocks inputs
    var selectors = [
        // Phones (classic + blocks)
        '#billing_phone', '#shipping_phone',
        '#billing-phone', '#shipping-phone',
        'input[name="billing-phone"]', 'input[name="shipping-phone"]',
        // Billing name/email (classic + blocks)
        '#billing_first_name', '#billing_last_name', '#billing_email',
        '#billing-first_name', '#billing-last_name', '#billing-email',
        'input[name="billing-first_name"]', 'input[name="billing-last_name"]', 'input[name="billing-email"]',
        // Shipping name/email (classic + blocks)
        '#shipping_first_name', '#shipping_last_name', '#shipping_email',
        '#shipping-first_name', '#shipping-last_name', '#shipping-email',
        'input[name="shipping-first_name"]', 'input[name="shipping-last_name"]', 'input[name="shipping-email"]'
    ].join(', ');

    function getVal(sel) {
        var $el = $(sel);
        if ($el.length) {
            return ($el.first().val() || '').trim();
        }
        return '';
    }

    function updateSessionDetails() {
        if (typeof bwc_ajax === 'undefined') return;
        var billingPhone = getVal('#billing_phone') || getVal('#billing-phone') || getVal('input[name="billing-phone"]');
        var shippingPhone = getVal('#shipping_phone') || getVal('#shipping-phone') || getVal('input[name="shipping-phone"]');
        var billingFirst = getVal('#billing_first_name') || getVal('#billing-first_name') || getVal('input[name="billing-first_name"]');
        var billingLast = getVal('#billing_last_name') || getVal('#billing-last_name') || getVal('input[name="billing-last_name"]');
        var billingEmail = getVal('#billing_email') || getVal('#billing-email') || getVal('input[name="billing-email"]') || getVal('input[name="email"]');
        var shippingFirst = getVal('#shipping_first_name') || getVal('#shipping-first_name') || getVal('input[name="shipping-first_name"]');
        var shippingLast = getVal('#shipping_last_name') || getVal('#shipping-last_name') || getVal('input[name="shipping-last_name"]');
        var shippingEmail = getVal('#shipping_email') || getVal('#shipping-email') || getVal('input[name="shipping-email"]');
        var data = {
            action: 'bwc_update_guest_details',
            nonce: bwc_ajax.nonce
        };

        if (billingPhone) {
            data.billing_phone = billingPhone;
        }

        if (shippingPhone) {
            data.shipping_phone = shippingPhone;
        }

        // Add names and emails if present
        if (billingFirst) data.billing_first_name = billingFirst;
        if (billingLast) data.billing_last_name = billingLast;
        if (billingEmail) data.billing_email = billingEmail;
        if (shippingFirst) data.shipping_first_name = shippingFirst;
        if (shippingLast) data.shipping_last_name = shippingLast;
        if (shippingEmail) data.shipping_email = shippingEmail;

        if (data.billing_phone || data.shipping_phone || data.billing_first_name || data.billing_last_name || data.billing_email || data.shipping_first_name || data.shipping_last_name || data.shipping_email) {
            $.post(bwc_ajax.ajax_url, data)
                .done(function (response) {
                    if (response && response.data && response.data.message) {
                        console.log('ACN:', response.data.message);
                    }
                })
                .fail(function () {
                    console.warn('ACN: failed to persist guest details.');
                });
        }
    }

    // Debounce to reduce network chatter on rapid input in block fields
    var t;
    function debouncedUpdate() {
        clearTimeout(t);
        t = setTimeout(updateSessionDetails, 400);
    }

    $(document.body).on('blur change input', selectors, debouncedUpdate);
});