<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Botamation_WooCommerce_Tools
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('bwc_abandoned_cart_settings');
delete_option('bwc_order_notification_settings');

// Drop database tables
global $wpdb;
$table_name = $wpdb->prefix . 'bwc_abandoned_carts';
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Clear any cached data
wp_cache_flush();

// Clear any scheduled cron jobs
wp_clear_scheduled_hook('bwc_process_abandoned_carts');
wp_clear_scheduled_hook('bwc_cleanup_abandoned_carts');